package hr.algebra.todo.model

import android.content.Context
import android.util.Log
import hr.algebra.todo.utils.canRead
import hr.algebra.todo.utils.canWrite
import java.io.File
private const val DIR = "todo"
private const val FILE = "items.txt"

//// /data/hr.algebra.todo/todo/ files.txt
class ItemList(private val context: Context) : ArrayList<Item>() {
    fun save() {
        if(!canWrite()) return
        try {
            File(context.getExternalFilesDir(DIR), FILE)
                .bufferedWriter()
                .use {
                    bw -> forEach { item -> bw.write(item.format()) }
                }
        } catch (e: Exception) {
            Log.e("FILE", e.toString(), e)
        }
    }
    fun load() {
        if(!canRead()) return
        try {
            File(context.getExternalFilesDir(DIR), FILE)
                .useLines {
                    lines -> lines.forEach { line -> add(Item.parse(line)) }
                }
        } catch (e: Exception) {
            Log.e("FILE", e.toString(), e)
        }
    }
}