package hr.algebra.listview

import android.os.Bundle
import android.widget.ArrayAdapter
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import hr.algebra.listview.adapter.ShowAdapter
import hr.algebra.listview.databinding.ActivityMainBinding
import hr.algebra.listview.model.Show

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        setAdapter()
    }

    private fun setAdapter() {
        val adapter = ShowAdapter(
            this,
            listOf(
                Show("Monty Python", R.drawable.monty_python),
                Show("Black Adder", R.drawable.black_adder),
                Show("Friends", R.drawable.friends)
            )
        )
        binding.lvShows.adapter = adapter
    }
}