package hr.algebra.listview.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ArrayAdapter
import android.widget.ImageView
import android.widget.TextView
import hr.algebra.listview.R
import hr.algebra.listview.model.Show

class ShowAdapter(context: Context, shows: List<Show>) :
    ArrayAdapter<Show>(context, 0, shows) {

    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {

        val viewHolder: ViewHolder
        var view = convertView
        if (view == null) {
            view = LayoutInflater
                .from(parent.context)
                .inflate(R.layout.show, parent, false)
            val ivShow = view.findViewById<ImageView>(R.id.ivShow)
            val tvShow = view.findViewById<TextView>(R.id.tvShow)

            viewHolder = ViewHolder(ivShow, tvShow)
            view.tag = viewHolder
        } else {
            viewHolder = view.tag as ViewHolder
        }

        val show = getItem(position)

        viewHolder.ivShow.setImageResource(show!!.picture)
        viewHolder.tvShow.text = show.title

        return view
    }
    private class ViewHolder(val ivShow: ImageView, val tvShow: TextView)

}