package hr.algebra.explicitintent

import android.content.Intent
import android.os.Bundle
import android.widget.Toast
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat

const val INPUT_PARAM_NAME = "hr.algebra.explicitintent.input_param"
const val OUTPUT_PARAM_NAME = "hr.algebra.explicitintent.output_param"

class CountVowelsActivity : AppCompatActivity() {

    private var nrVowels = 0

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        handleIntent()
    }

    private fun handleIntent() {
        intent.getStringExtra(INPUT_PARAM_NAME)?.let {
            //Toast.makeText(this, it, Toast.LENGTH_SHORT).show()
            nrVowels = countVowels(it)
        }
    }

    private fun countVowels(text: String) = text
        .lowercase()
        .replace("[^aeiou]".toRegex(), "")
        .length

    override fun finish() {
        setResult(RESULT_OK, Intent().apply {
            putExtra(OUTPUT_PARAM_NAME, nrVowels)
        })
        super.finish()
    }

}