package hr.algebra.broadcastsalarmsnotifications

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.media.MediaPlayer
import android.os.Handler
import android.os.Looper

import android.provider.Settings
import androidx.core.content.getSystemService

private const val DURATION = 2000L

private const val NOTIFICATION_ID = 1
private const val CHANNEL_ID = "channel_id"
private val CHANNEL_TITLE: CharSequence = "channel_title"

class AlarmReceiver : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent) {
        playRingtone(context, DURATION)
        sendNotification(context)
    }

    private fun sendNotification(context: Context) {
        val intent = Intent(context, MainActivity::class.java)
        val pendingIntent = PendingIntent.getActivity(
            context,
            NOTIFICATION_ID,
            intent,
            PendingIntent.FLAG_MUTABLE
        )

        val notificationManager = context.getSystemService<NotificationManager>()!!

        val channel = NotificationChannel(CHANNEL_ID, CHANNEL_TITLE, NotificationManager.IMPORTANCE_DEFAULT)
        notificationManager.createNotificationChannel(channel)

        val builder = Notification.Builder(context, channel.id).apply {
            setContentTitle(context.getString(R.string.
            wake_up))
            setContentText(context.getString(R.string.cmon))
            setSmallIcon(R.drawable.watch)
            setAutoCancel(true)
            setContentIntent(pendingIntent)
        }

        notificationManager.notify(NOTIFICATION_ID, builder.build())
    }
    private fun playRingtone(context: Context, duration: Long) {
        //val mediaPlayer = MediaPlayer.create(context, Settings.System.DEFAULT_RINGTONE_URI)
        val mediaPlayer = MediaPlayer.create(context, R.raw.sound)
        mediaPlayer.start()
        Handler(Looper.getMainLooper()).postDelayed({
            mediaPlayer.stop()
        }, duration)
    }
}