package hr.algebra.broadcastsalarmsnotifications

import android.app.AlarmManager
import android.app.PendingIntent
import android.content.Intent
import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.getSystemService
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import hr.algebra.broadcastsalarmsnotifications.databinding.ActivityMainBinding
import java.util.Calendar

private const val REQUEST_CODE = 1
private const val DELAY = 6

class MainActivity : AppCompatActivity() {
    private lateinit var binding: ActivityMainBinding

    private lateinit var alarmManager: AlarmManager

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)
        initAlarmManager()
        setupListeners()
    }

    private fun initAlarmManager() {
        alarmManager = getSystemService()!!
    }

    private fun setupListeners() {
        binding.btnStart.setOnClickListener {
            val calendar = Calendar.getInstance() // factory // java.util
            calendar.add(Calendar.SECOND, DELAY)

            val intent = Intent(this, AlarmReceiver::class.java)
            val pendingIntent = PendingIntent.getBroadcast(
                this,
                REQUEST_CODE,
                intent,
                PendingIntent.FLAG_MUTABLE)

            alarmManager.set(AlarmManager.RTC_WAKEUP, calendar.timeInMillis, pendingIntent)
            finish()

        }
    }
}