package hr.algebra.reflection.classloader;

public class LazyInit {
    public static void main(String[] args) {
        // lazy initialization
        // 1. step - this does not initialize
        Class<?> dummy = Dummy.class;

        //2. step - this does not initialize (false as initialize param -> true would load it)
        try {
            //Class.forName("hr.algebra.reflection.classloader.Dummy", false, dummy.getClassLoader());
            Class.forName("hr.algebra.reflection.classloader.Dummy", false, dummy.getClassLoader());

        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }

        // comment out code above
        //3. step - creation of object must initialize the class!
        new Dummy();
    }
}
