package hr.algebra.reflection.factory;

import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;

public class ShapeUsage {
    public static void main(String[] args) {
        try {
            Stream<Shape> shapes = Stream.of(
                    GenericFactory.get(Circle.class.getName()),
                    GenericFactory.get(Rectangle.class.getName()),
                    GenericFactory.get(Square.class.getName())
            );
            shapes.forEach(Shape::draw);

        } catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}
