package hr.algebra.reflection.info;

import hr.algebra.reflection.utils.ReflectionUtils;

import java.lang.reflect.Field;

public class MembersInfo {
    public static void main(String[] args) {
        Student student = new Student("Milica", "Krmpotic", 3, 4.5);

        StringBuilder classAndMembersInfo = new StringBuilder();
        ReflectionUtils.readClassAndMembersInfo(student.getClass(), classAndMembersInfo);
        System.out.println(classAndMembersInfo);

        breakEncapsulation(student);
    }

    private static void breakEncapsulation(Student student) {
        try {
            showFields(student);
            changeFields(student);
            showFields(student);
        } catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }

    }

    private static void showFields(Student student) throws IllegalAccessException {
        System.out.println("Student fields:");
        for (Field field : student.getClass().getDeclaredFields()) {
            if (!field.canAccess(student)) {
                field.setAccessible(true);
            }
            Object value = field.get(student);
            System.out.printf("%s = %s%n", field.getName(), value);
        }
    }

    private static void changeFields(Student student) throws NoSuchFieldException, IllegalAccessException {
        student.getClass().getDeclaredField("firstName").set(student, "Gojko");
        student.getClass().getDeclaredField("lastName").set(student, "Mrnjavcevic");
        student.getClass().getDeclaredField("yearOfStudy").set(student, 1);
        Field average = student.getClass().getDeclaredField("average");
        average.setAccessible(true);
        average.set(student, 2.9);
    }

}
