package hr.algebra.concurrency.synchronization;

import hr.algebra.concurrency.utilities.ThreadUtils;

import java.util.List;
import java.util.concurrent.*;

public class Demo {
    public static void main(String[] args) {

        //semaphore();
        //countDownLatch();
        cyclicBarrier();

    }

    private static void semaphore() {
        final int nrThreads = 5;
        final int permits = 3; // 1

        ExecutorService executorService = Executors.newFixedThreadPool(nrThreads);
        Semaphore semaphore = new Semaphore(permits, true); // false can cause starvation :)

        Runnable runnable = () -> {
            while (true) {
                try {
                    semaphore.acquire();
                    System.out.println("+++++++++++ acquired by: " + Thread.currentThread());
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    return;
                } finally {
                    System.out.println("----------- releasing by: " + Thread.currentThread());
                    semaphore.release();
                }
            }
        };
        for (int i = 0; i < nrThreads; i++) {
            executorService.execute(runnable);
        }

        ThreadUtils.stopExecutor(executorService, 6, TimeUnit.SECONDS);
    }

    private static void countDownLatch() { // nalik join(), ali sofisticirano i jednostavnije

        ExecutorService executorService = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(2);

        List<Runnable> services = List.of(
                () -> {
                    try {
                        System.out.println("Server starting...");
                        Thread.sleep(2000);
                        System.out.println("Server started!");
                        countDownLatch.countDown();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                },
                () -> {
                    try {
                        System.out.println("Database daemon starting...");
                        Thread.sleep(3000);
                        System.out.println("Database daemon started!;");
                        countDownLatch.countDown();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });


        services.forEach(executorService::execute);

        try {
            countDownLatch.await();
            executorService.shutdown();
            System.out.println("Client started");
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void cyclicBarrier() {

        CyclicBarrier cyclicBarrier = new CyclicBarrier(3);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(cyclicBarrier.getParties());
        Runnable runnable = () -> {
            try {
                System.out.println("Player is ready: " + Thread.currentThread());
                cyclicBarrier.await();
                System.out.println("Game starts for player: " + Thread.currentThread());
            } catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
        };
        for (int i = 0; i < cyclicBarrier.getParties(); i++) {
            executorService.schedule(runnable, i * 2, TimeUnit.SECONDS);
        }
        executorService.shutdown();
    }

}


