package hr.algebra.trirp1.tictactoe.tictactoe3rp11;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.controller.TicTacToeMainController;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.jndi.ConfigurationKey;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.jndi.ConfigurationReader;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.PlayerType;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.DialogUtils;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.GameUtils;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Stage;

import javax.swing.*;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class TicTacToeApplication extends Application {

    public static PlayerType playerType;
    //public static final int PORT_PLAYER_2 = 1989;
    //public static final int PORT_PLAYER_1 = 1980;

    @Override
    public void start(Stage stage) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(TicTacToeApplication.class.getResource("tic-tac-tor.fxml"));
        Scene scene = new Scene(fxmlLoader.load(), 800, 800);
        stage.setTitle("Križić - kružić - " + playerType.toString());
        stage.setScene(scene);
        stage.show();

        if(!PlayerType.SINGLE_PLAYER.name().equals(playerType.name())) {
            if (PlayerType.PLAYER_2.name().equals(playerType.name())) {
                Thread serverThread = new Thread(() -> acceptRequests(
                        ConfigurationReader.getIntegerValueForKey(ConfigurationKey.PLAYER_2_SERVER_PORT)));
                serverThread.start();
            }
            else {
                Thread serverThread = new Thread(() -> acceptRequests(
                        ConfigurationReader.getIntegerValueForKey(ConfigurationKey.PLAYER_1_SERVER_PORT)));
                serverThread.start();
            }
        }
    }

    public static void main(String[] args) {

        String firstCommandLineArg = args[0];

        Boolean playerTypeExists = false;

        for (PlayerType playerType : PlayerType.values()) {
            if (firstCommandLineArg.equals(playerType.toString())) {
                playerTypeExists = true;
                break;
            }
        }

        if(!playerTypeExists) {
            System.out.println("You provided a player type that does not exist!");
            JOptionPane.showMessageDialog(null,
                    "You provided a player type that does not exist!");
            System.exit(0);
        }
        else {
            playerType = PlayerType.valueOf(firstCommandLineArg);
            launch();
        }
    }

    private static void acceptRequests(Integer port) {
        try (ServerSocket serverSocket = new ServerSocket(port)){
            System.err.printf("Server listening on port: %d%n", serverSocket.getLocalPort());

            while (true) {
                Socket clientSocket = serverSocket.accept();
                System.err.printf("Client connected from port %s%n", clientSocket.getPort());
                new Thread(() ->  processSerializableClient(clientSocket)).start();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processSerializableClient(Socket clientSocket) {
        try (ObjectInputStream ois = new ObjectInputStream(clientSocket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(clientSocket.getOutputStream());){
            GameState gameState = (GameState)ois.readObject();
            TicTacToeMainController.restoreGameState(gameState);

            Boolean winnerExists = GameUtils.winnerExists(gameState.getBoard(), gameState.getTurn());

            if(gameState.getTurn().name().equals(TicTacToeMainController.turn.name())) {
                TicTacToeMainController.disableButtons(false);
            }
            else {
                TicTacToeMainController.disableButtons(true);
            }

            if(winnerExists) {
                Platform.runLater(() -> {
                            DialogUtils.showDialog("Pobijedio je " + gameState.getTurn().name(),
                                    "Pobjednik je igrač koji koristi simbol " + gameState.getTurn().name(),
                                    Alert.AlertType.INFORMATION);
                        });

                    TicTacToeMainController.disableButtons(true);
            }

            System.out.println("Game state received from Player 1");
            oos.writeObject("Success");

            System.out.println("Winner exists: " + winnerExists);
            System.out.println("Turn: " + gameState.getTurn().toString());

            if(!winnerExists && !gameState.getNewGame()) {
                System.out.println("WinnerExists & Not a new game");
                Platform.runLater(() -> TicTacToeMainController.disableButtons(false));
            }

            if(!winnerExists && gameState.getNumberOfTurns() ==
                    GameUtils.NUMBER_OF_COLUMNS * GameUtils.NUMBER_OF_ROWS) {
                Platform.runLater(() -> DialogUtils.showDialog("Neriješeno!", "Nema pobjednika!",
                        Alert.AlertType.INFORMATION));
                TicTacToeMainController.disableButtons(true);
            }

        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void sendRequestPlayerOne(GameState gameState) {
        try (Socket clientSocket = new Socket(
                ConfigurationReader.getStringValueForKey(ConfigurationKey.HOSTNAME),
                ConfigurationReader.getIntegerValueForKey(ConfigurationKey.PLAYER_2_SERVER_PORT))){
            System.err.printf("Client is connecting to %s:%d%n", clientSocket.getInetAddress(), clientSocket.getPort());

            sendSerializableRequest(clientSocket, gameState);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void sendRequestPlayerTwo(GameState gameState) {
        try (Socket clientSocket = new Socket(ConfigurationReader.getStringValueForKey(ConfigurationKey.HOSTNAME),
                ConfigurationReader.getIntegerValueForKey(ConfigurationKey.PLAYER_1_SERVER_PORT)))
        {
            System.err.printf("Client is connecting to %s:%d%n", clientSocket.getInetAddress(), clientSocket.getPort());

            sendSerializableRequest(clientSocket, gameState);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void sendSerializableRequest(Socket client, GameState gameState) throws IOException, ClassNotFoundException {
        ObjectOutputStream oos = new ObjectOutputStream(client.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(client.getInputStream());
        oos.writeObject(gameState);
        System.out.println("GameState sent to Player2");
        System.out.println(ois.readObject());
    }
}