package hr.algebra.trirp1.tictactoe.tictactoe3rp11.thread;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameMove;
import javafx.application.Platform;
import javafx.scene.control.Label;

import java.util.List;
import java.util.Objects;

public class ReadTheLastGameMoveThread extends AbstractTheLastGameMoveThread implements Runnable {

    private Label label;

    public ReadTheLastGameMoveThread(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public void run() {

        List<GameMove> gameMoves = loadGameMoves();

        if (!gameMoves.isEmpty()) {

            GameMove lastMove = gameMoves.getLast();
            Platform.runLater(
                    () -> label.setText(lastMove.getSymbol() + " position: ("
                            + lastMove.getPosition().getRow() + ", "
                            + lastMove.getPosition().getColumn() + ")")
            );

        }
    }
}
