﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DemoReference
{
    internal class Program
    {
        static void Main(string[] args)
        {
            int i = 1;
            PassByValue(i);
            Console.WriteLine($"Main PassByValue i = {i}");

            int j = 1;
            PassByReferenceRef(ref j);
            Console.WriteLine($"Main PassByReferenceRef j = {j}");

            int k;
            PassByReferenceOut(out k);
            Console.WriteLine($"Main PassByReferenceOut k = {k}");

            int[] numbers = new int[] { 1, 2, 3 };
            PassArray(numbers);
            Console.WriteLine($"PassArray 1. element = {numbers[0]}");
        }

        private static void PassArray(int[] numbers)
        {
            numbers[0] = 10;
        }

        private static void PassByReferenceOut(out int k)
        {
            k = 1;
            k++;
            Console.WriteLine($"PassByReferenceOut k = {k}");
        }

        private static void PassByReferenceRef(ref int j)
        {
            j++;
            Console.WriteLine($"PassByReferenceRef j = {j}");
        }

        private static void PassByValue(int i)
        {
            i++;
            Console.WriteLine($"PassByValue i = {i}");
        }
    }
}
